/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8273;

import ibm.nways.jdm.GraphicActionNavigate;
import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicFlyOver;
import ibm.nways.jdm.GraphicHelp;
import ibm.nways.jdm.GraphicImage;
import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.HelpRef;
import ibm.nways.jdm.I18NMsgFormat;
import ibm.nways.jdm.I18NString;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.NavInitialRow;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.NavigationDestination;
import ibm.nways.jdm.RemoteStatus;
import ibm.nways.jdm.StatusImpl;
import ibm.nways.jdm.StatusProxy;
import ibm.nways.jdm.StatusType;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm8273.RsBoxConfig;
import ibm.nways.jdm8273.RsModule;
import ibm.nways.jdm8273.RsPort;
import java.awt.Point;
import java.util.ResourceBundle;

public class Rs8273Graphic {
    private static String bundleName = "ibm.nways.jdm8273.Rs8273Resources";
    private static String FddiNotSupported = "FddiNotSupported";
    private static String CddiNotSupported = "CddiNotSupported";
    private static String AtmSubmoduleFlyOver = "AtmSubmoduleFlyOver";
    private static String AtmPortFlyOver = "AtmPortFlyOver";
    private static String FddiSubmoduleFlyOver = "FddiSubmoduleFlyOver";
    private static String CddiSubmoduleFlyOver = "CddiSubmoduleFlyOver";
    private static String UnknownSubmoduleFlyOver = "UnknownSubmoduleFlyOver";
    private ResourceBundle myResources;
    static final String HelpRef_Dir = "ibm.nways.jdm8273";
    static final String HelpRef_Mod100html = "ibm.nways.jdm8273.BoxGraphic.html";
    static final String HelpRef_Mod10Uhtml = "ibm.nways.jdm8273.BoxGraphic.html";
    static final String Class_SystemPanel = "ibm.nways.mib2.SystemInfoPanel";
    static final String Class_MpmPanel = "ibm.nways.jdm8273.eui.MpmBasePanel";
    static final String Class_EthPortsPanel = "ibm.nways.jdm8273.EthPortsPanel";
    static final String Class_AtmPortsPanel = "ibm.nways.jdm8273.eui.AtmPortsBasePanel";
    static final String Class_FastEthPortsPanel = "ibm.nways.jdm8273.FastEthPortsPanel";
    static final String Gif_8273100Backplane = "8273100.gif";
    static final String Gif_827310UBackplane = "827310u.gif";
    static final String Gif_Submodule_AtmOc3 = "suboc3.gif";
    static final String Gif_Submodule_100BaseTx = "sub100tx.gif";
    static final String Gif_Submodule_Fddi = "subfddi.gif";
    static final String Gif_Submodule_Cddi = "subcddi.gif";
    static final String Gif_Submodule_Unknown = "unknown.gif";
    static final String Gif_RJ45SingleConnector = "rj45a.gif";
    static final String Gif_RJ45LeftConnector = "rj45b.gif";
    static final String Gif_RJ45MiddleConnector = "rj45c.gif";
    static final String Gif_RJ45RightConnector = "rj45d.gif";
    static final String Gif_10BaseFlConnector = "st.gif";
    static final String Gif_BncConnector = "bnc.gif";
    static final String Gif_AuiConnector = "db15f.gif";
    static final String Gif_ScConnector = "sc.gif";
    static final String Gif_FddiBypassConnector = "fddi.gif";
    static final String Gif_ConsoleConnector = "rs232f.gif";
    static final String Gif_UnknownPort = "unknown.gif";
    static final int XCoord_Backplane = 20;
    static final int YCoord_Backplane = 0;
    static final int XCoord_ConsolePort = 547;
    static final int YCoord_ConsolePort = 49;
    static final int XCoord_Submodule0 = 65;
    static final int YCoord_Submodule0 = 130;
    static final int XCoord_Submodule1 = 295;
    static final int YCoord_Submodule1 = 130;
    static final int XCoord_Mod100Help = 0;
    static final int YCoord_Mod100Help = 23;
    static final int XCoord_Mod100Port1 = 270;
    static final int YCoord_Mod100Port1 = 49;
    static final int XWidth_RJ45LeftConnector = 20;
    static final int XWidth_RJ45MiddleConnector = 19;
    static final int XWidth_RJ45RightConnector = 21;
    static final int XCoord_Mod10UHelp = 0;
    static final int YCoord_Mod10UHelp = 23;
    static final int XCoord_Mod10UPort1 = 146;
    static final int YCoord_Mod10UPort1 = 50;
    static final int XWidth_Mod10UPort = 49;
    static final int XCoord_AtmPort = 125;
    static final int YCoord_AtmPort = 15;
    static final int XCoord_100BaseTPort1 = 95;
    static final int YCoord_100BaseTPort1 = 30;
    static final int XWidth_100BaseTPort = 24;
    static final int XCoord_UnknownSymbol = 73;
    static final int YCoord_UnknownSymbol = 10;
    private JdmBrowser parentJdm;
    private RsBoxConfig chassisConfig;
    private static String SystemComponent = "System";
    private static String ChassisMpmComponent = "ChassisMpm";
    private static String PhyPortComponent = "PhyPort";
    private static String PhyPortWithStatusComponent = "PhyPortWithStatus";
    private static String AtmxPortComponent = "AtmxPort";
    private GenModel deviceModel = null;
    private GenModel chassisMpmModel = null;
    private GenModel phyPortModel = null;
    private GenModel phyPortWithStatusModel = null;
    private GenModel atmxPortModel = null;
    private GenModel mib2SystemModel;

    private static String getBundleName() {
        return bundleName;
    }

    private static String PhyPortNotAccessible() {
        return "PhyPortNotAccessible";
    }

    private static String MpmConsoleFlyOver() {
        return "MpmConsoleFlyOver";
    }

    private static String EthPortFlyOver() {
        return "EthPortFlyOver";
    }

    private static String FastEthSubmoduleFlyOver() {
        return "FastEthSubmoduleFlyOver";
    }

    public Rs8273Graphic(JdmBrowser jdmBrowser, RsBoxConfig rsBoxConfig) {
        this.parentJdm = jdmBrowser;
        this.chassisConfig = rsBoxConfig;
        this.myResources = ResourceBundle.getBundle(bundleName);
    }

    protected ResourceBundle getMyResources() {
        return this.myResources;
    }

    public void setModel(GenModel genModel) {
        this.deviceModel = genModel;
        try {
            this.phyPortModel = (GenModel)this.deviceModel.getComponent(PhyPortComponent);
            this.chassisMpmModel = (GenModel)this.deviceModel.getComponent(ChassisMpmComponent);
            this.phyPortWithStatusModel = (GenModel)this.deviceModel.getComponent(PhyPortWithStatusComponent);
            this.atmxPortModel = (GenModel)this.deviceModel.getComponent(AtmxPortComponent);
            this.mib2SystemModel = (GenModel)this.deviceModel.getComponent(SystemComponent);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public GraphicPanel getGraphicPanel() {
        GraphicContainer graphicContainer = new GraphicContainer();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            bl2 = this.chassisConfig.is8273mod100();
            bl = this.chassisConfig.is8273mod10u();
            if (bl2) {
                this.build8273mod100(graphicContainer);
            } else if (bl) {
                this.build8273mod10u(graphicContainer);
            } else {
                bl3 = true;
            }
            if (!bl3) {
                int[] nArray = new int[]{3, 3};
                RsPort[] rsPortArray = new RsPort[]{null, null};
                Point[] pointArray = new Point[]{null, null};
                pointArray[0] = new Point(65, 130);
                pointArray[1] = new Point(295, 130);
                RsModule rsModule = this.chassisConfig.getModuleWithNum(3);
                int n = rsModule.getNumOfSubUnits();
                int n2 = 0;
                while (n2 < n) {
                    switch (rsModule.getSubUnitPosOf(n2)) {
                        case 2: {
                            nArray[0] = rsModule.getSubUnitTypeAt(n2);
                            rsPortArray[0] = rsModule.getPortAt(n2);
                            break;
                        }
                        case 3: {
                            nArray[1] = rsModule.getSubUnitTypeAt(n2);
                            rsPortArray[1] = rsModule.getPortAt(n2);
                            break;
                        }
                    }
                    ++n2;
                }
                if (rsPortArray[1] == null && (rsModule = this.chassisConfig.getModuleWithNum(4)) != null) {
                    nArray[1] = rsModule.getSubUnitTypeAt(0);
                    rsPortArray[1] = rsModule.getPortAt(0);
                }
                int n3 = 0;
                while (n3 < 2) {
                    if (rsPortArray[n3] != null) {
                        switch (nArray[n3]) {
                            case 12: 
                            case 18: 
                            case 23: 
                            case 24: {
                                this.buildAtmSubmodule(graphicContainer, pointArray[n3], rsPortArray[n3]);
                                break;
                            }
                            case 11: {
                                this.build100BaseTSubmodule(graphicContainer, pointArray[n3], rsPortArray[n3]);
                                break;
                            }
                            case 9: 
                            case 17: {
                                this.buildFddiSubmodule(graphicContainer, pointArray[n3]);
                                break;
                            }
                            case 10: {
                                this.buildCddiSubmodule(graphicContainer, pointArray[n3]);
                                break;
                            }
                            default: {
                                this.buildUnknownSubmodule(graphicContainer, pointArray[n3]);
                                break;
                            }
                        }
                    }
                    ++n3;
                }
            }
        }
        catch (Exception exception) {
            bl3 = true;
            exception.printStackTrace();
        }
        GraphicPanel graphicPanel = !bl3 ? new GraphicPanel(this.parentJdm, graphicContainer) : null;
        return graphicPanel;
    }

    private void build8273mod100(GraphicContainer graphicContainer) {
        GraphicImage graphicImage = new GraphicImage(this.parentJdm.imageFrom(this, Gif_8273100Backplane), new Point(20, 0), 2, new GraphicActionNavigate(this.parentJdm, new NavigationDestination(Class_SystemPanel, this.mib2SystemModel), null), null);
        graphicContainer.add(graphicImage);
        HelpRef helpRef = new HelpRef(HelpRef_Dir, "ibm.nways.jdm8273.BoxGraphic.html");
        graphicImage = new GraphicHelp(this.parentJdm, new Point(0, 23), helpRef);
        graphicContainer.add(graphicImage);
        graphicImage = new ConsolePortGraphic(this.parentJdm, this.chassisMpmModel);
        graphicContainer.add(graphicImage);
        int n = 12;
        int n2 = 2;
        int n3 = 270;
        int n4 = 49;
        RsModule rsModule = this.chassisConfig.getModuleWithNum(n2);
        int n5 = 1;
        while (n5 <= n) {
            int n6;
            String string;
            RsPort rsPort = rsModule.getPortWithNum(n5);
            switch (n5) {
                case 1: 
                case 7: {
                    string = Gif_RJ45LeftConnector;
                    n6 = 20;
                    break;
                }
                case 6: 
                case 12: {
                    string = Gif_RJ45RightConnector;
                    n6 = 21;
                    break;
                }
                default: {
                    string = Gif_RJ45MiddleConnector;
                    n6 = 19;
                }
            }
            if (rsPort != null) {
                graphicImage = new EthernetPortGraphic(this.parentJdm, n3, n4, string, this.phyPortModel, this.phyPortWithStatusModel, rsPort);
                graphicContainer.add(graphicImage);
            }
            n3 += n6;
            ++n5;
        }
    }

    private void build8273mod10u(GraphicContainer graphicContainer) {
        GraphicImage graphicImage = new GraphicImage(this.parentJdm.imageFrom(this, Gif_827310UBackplane), new Point(20, 0), 2, new GraphicActionNavigate(this.parentJdm, new NavigationDestination(Class_SystemPanel, this.mib2SystemModel), null), null);
        graphicContainer.add(graphicImage);
        HelpRef helpRef = new HelpRef(HelpRef_Dir, "ibm.nways.jdm8273.BoxGraphic.html");
        graphicImage = new GraphicHelp(this.parentJdm, new Point(0, 23), helpRef);
        graphicContainer.add(graphicImage);
        graphicImage = new ConsolePortGraphic(this.parentJdm, this.chassisMpmModel);
        graphicContainer.add(graphicImage);
        int n = 2;
        RsModule rsModule = null;
        int n2 = 8;
        int n3 = 146;
        int n4 = 50;
        int n5 = 49;
        rsModule = this.chassisConfig.getModuleWithNum(n);
        int n6 = 1;
        while (n6 <= n2) {
            RsPort rsPort = rsModule.getPortWithNum(n6);
            if (rsPort != null) {
                BackgroundItem backgroundItem = this.mapPortTypeToGif(rsPort.getPortType());
                graphicImage = new EthernetPortGraphic(this.parentJdm, n3 + backgroundItem.xCoord, n4 + backgroundItem.yCoord, backgroundItem.gifFile, this.phyPortModel, this.phyPortWithStatusModel, rsPort);
                graphicContainer.add(graphicImage);
            }
            n3 += n5;
            ++n6;
        }
    }

    private void buildAtmSubmodule(GraphicContainer graphicContainer, Point point, RsPort rsPort) {
        Object object;
        GraphicImage graphicImage = new GraphicImage(this.parentJdm.imageFrom(this, Gif_Submodule_AtmOc3), new Point(point.x, point.y), 1);
        graphicImage.setFlyOver(new GraphicFlyOver(this.getMyResources().getString(AtmSubmoduleFlyOver)));
        graphicContainer.add(graphicImage);
        Point point2 = new Point(point.x + 125, point.y + 15);
        StatusImpl statusImpl = null;
        ModelInfo modelInfo = new ModelInfo();
        modelInfo.add("Index.Slot", new Integer(rsPort.getSlotNum()));
        modelInfo.add("Index.Port", new Integer(rsPort.getPortNum()));
        try {
            object = this.atmxPortModel.getStatusRefForRow(modelInfo);
            statusImpl = new StatusProxy((RemoteStatus)object);
        }
        catch (Exception exception) {
            statusImpl = new StatusImpl();
            Object[] objectArray = new Object[]{new Integer(rsPort.getSlotNum()), new Integer(rsPort.getPortNum())};
            I18NMsgFormat i18NMsgFormat = new I18NMsgFormat(bundleName, Rs8273Graphic.PhyPortNotAccessible(), objectArray);
            statusImpl.setStatusType(StatusType.UNKNOWN, i18NMsgFormat, false);
            exception.printStackTrace();
        }
        object = new NavigationContext();
        NavInitialRow.setInitialRow((NavigationContext)object, modelInfo);
        graphicImage = new GraphicImage(this.parentJdm.imageFrom(this, Gif_ScConnector), point2, 0, new GraphicActionNavigate(this.parentJdm, new NavigationDestination(Class_AtmPortsPanel, this.atmxPortModel), (NavigationContext)object), statusImpl);
        graphicImage.setFlyOver(new GraphicFlyOver(this.getMyResources().getString(AtmPortFlyOver)));
        graphicContainer.add(graphicImage);
    }

    private void build100BaseTSubmodule(GraphicContainer graphicContainer, Point point, RsPort rsPort) {
        EthernetPortGraphic ethernetPortGraphic = new EthernetPortGraphic(this.parentJdm, point.x, point.y, Gif_Submodule_100BaseTx, this.phyPortModel, this.phyPortWithStatusModel, rsPort, true);
        graphicContainer.add(ethernetPortGraphic);
    }

    private void buildFddiSubmodule(GraphicContainer graphicContainer, Point point) {
        StatusImpl statusImpl = new StatusImpl();
        I18NString i18NString = new I18NString(bundleName, FddiNotSupported);
        statusImpl.setStatusType(StatusType.UNMANAGED, i18NString, false);
        GraphicImage graphicImage = new GraphicImage(this.parentJdm.imageFrom(this, Gif_Submodule_Fddi), new Point(point.x, point.y), 1, null, statusImpl);
        graphicImage.setFlyOver(new GraphicFlyOver(this.getMyResources().getString(FddiSubmoduleFlyOver)));
        graphicContainer.add(graphicImage);
    }

    private void buildCddiSubmodule(GraphicContainer graphicContainer, Point point) {
        StatusImpl statusImpl = new StatusImpl();
        I18NString i18NString = new I18NString(bundleName, CddiNotSupported);
        statusImpl.setStatusType(StatusType.UNMANAGED, i18NString, false);
        GraphicImage graphicImage = new GraphicImage(this.parentJdm.imageFrom(this, Gif_Submodule_Cddi), new Point(point.x, point.y), 1, null, statusImpl);
        graphicImage.setFlyOver(new GraphicFlyOver(this.getMyResources().getString(CddiSubmoduleFlyOver)));
        graphicContainer.add(graphicImage);
    }

    private void buildUnknownSubmodule(GraphicContainer graphicContainer, Point point) {
        GraphicImage graphicImage = new GraphicImage(this.parentJdm.imageFrom(this, "unknown.gif"), new Point(point.x + 73, point.y + 10), 1);
        graphicImage.setFlyOver(new GraphicFlyOver(this.getMyResources().getString(UnknownSubmoduleFlyOver)));
        graphicContainer.add(graphicImage);
    }

    private BackgroundItem mapPortTypeToGif(int n) {
        BackgroundItem backgroundItem = null;
        switch (n) {
            case 5: {
                backgroundItem = new BackgroundItem(Gif_RJ45SingleConnector, 14, 0);
                break;
            }
            case 7: {
                backgroundItem = new BackgroundItem(Gif_AuiConnector, 2, 0);
                break;
            }
            case 8: {
                backgroundItem = new BackgroundItem(Gif_BncConnector, 15, 0);
                break;
            }
            case 9: {
                backgroundItem = new BackgroundItem(Gif_10BaseFlConnector, 7, 3);
                break;
            }
            case 23: 
            case 24: {
                backgroundItem = new BackgroundItem(Gif_AuiConnector, 2, 0);
                break;
            }
            default: {
                backgroundItem = new BackgroundItem("unknown.gif", 2, 0);
            }
        }
        return backgroundItem;
    }

    private class ConsolePortGraphic
    extends GraphicImage {
        ConsolePortGraphic(JdmBrowser jdmBrowser, GenModel genModel) {
            super(jdmBrowser.imageFrom(jdmBrowser, Rs8273Graphic.Gif_ConsoleConnector), new Point(547, 49), 1, new GraphicActionNavigate(jdmBrowser, new NavigationDestination(Rs8273Graphic.Class_MpmPanel, genModel), null), null);
            Rs8273Graphic.this = Rs8273Graphic.this;
            StatusImpl statusImpl = new StatusImpl();
            statusImpl.setStatusType(StatusType.NORMAL, null, true);
            this.setStatus(statusImpl);
            this.setFlyOver(new GraphicFlyOver(Rs8273Graphic.this.getMyResources().getString(Rs8273Graphic.MpmConsoleFlyOver())));
        }
    }

    private class EthernetPortGraphic
    extends GraphicImage {
        EthernetPortGraphic(JdmBrowser jdmBrowser, int n, int n2, String string, GenModel genModel, GenModel genModel2, RsPort rsPort) {
            this(jdmBrowser, n, n2, string, genModel, genModel2, rsPort, false);
        }

        EthernetPortGraphic(JdmBrowser jdmBrowser, int n, int n2, String string, GenModel genModel, GenModel genModel2, RsPort rsPort, boolean bl) {
            super(jdmBrowser.imageFrom(jdmBrowser, string), new Point(n, n2), 1);
            Rs8273Graphic.this = Rs8273Graphic.this;
            ModelInfo modelInfo = new ModelInfo();
            modelInfo.add("Index.Slot", new Integer(rsPort.getSlotNum()));
            modelInfo.add("Index.Port", new Integer(rsPort.getPortNum()));
            NavigationContext navigationContext = new NavigationContext();
            NavInitialRow.setInitialRow(navigationContext, modelInfo);
            String string2 = bl ? Rs8273Graphic.Class_FastEthPortsPanel : Rs8273Graphic.Class_EthPortsPanel;
            GraphicActionNavigate graphicActionNavigate = new GraphicActionNavigate(jdmBrowser, new NavigationDestination(string2, genModel), navigationContext);
            this.setAction(graphicActionNavigate);
            StatusImpl statusImpl = null;
            modelInfo = new ModelInfo();
            modelInfo.add("Index.Slot", new Integer(rsPort.getSlotNum()));
            modelInfo.add("Index.Port", new Integer(rsPort.getPortNum()));
            try {
                RemoteStatus remoteStatus = genModel2.getStatusRefForRow(modelInfo);
                statusImpl = new StatusProxy(remoteStatus);
            }
            catch (Exception exception) {
                statusImpl = new StatusImpl();
                Object[] objectArray = new Object[]{new Integer(rsPort.getSlotNum()), new Integer(rsPort.getPortNum())};
                I18NMsgFormat i18NMsgFormat = new I18NMsgFormat(Rs8273Graphic.getBundleName(), Rs8273Graphic.PhyPortNotAccessible(), objectArray);
                statusImpl.setStatusType(StatusType.UNKNOWN, i18NMsgFormat, false);
                exception.printStackTrace();
            }
            this.setStatus(statusImpl);
            if (bl) {
                this.setFlyOver(new GraphicFlyOver(Rs8273Graphic.this.getMyResources().getString(Rs8273Graphic.FastEthSubmoduleFlyOver())));
                return;
            }
            this.setFlyOver(new GraphicFlyOver(String.valueOf(Rs8273Graphic.this.getMyResources().getString(Rs8273Graphic.EthPortFlyOver())) + " " + rsPort.getPortNum()));
        }
    }

    private class BackgroundItem {
        String gifFile;
        int xCoord;
        int yCoord;

        public BackgroundItem(String string, int n, int n2) {
            Rs8273Graphic.this = Rs8273Graphic.this;
            this.gifFile = string;
            this.xCoord = n;
            this.yCoord = n2;
        }
    }
}

